package com.example.sefinsa_app.utilities;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.text.Html;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.core.content.ContextCompat;
import androidx.core.net.ParseException;
import androidx.recyclerview.widget.RecyclerView;

import com.example.sefinsa_app.R;
import com.example.sefinsa_app.models.ReporteHistorial;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class ReporteHistorialAdapter extends RecyclerView.Adapter<ReporteHistorialAdapter.ReportesHistorialViewHolder>{

    Context context;
    ArrayList<ReporteHistorial> reportes;
    private String modalidad_id;
    private int numSemanas;
    private boolean isHeaderCreated = false; // Verifica si el encabezado ya se generó

    public ReporteHistorialAdapter(Context context, ArrayList<ReporteHistorial> reportes) {
        this.context = context;
        this.reportes = reportes;
    }
    public void actualizarModalidad(String modalidad_id) {
        // Establecer el modalidad_id
        this.modalidad_id = modalidad_id;

        // Actualizar el número de semanas según modalidad_id
        if (modalidad_id.equals("1")) {
            numSemanas = 15;
        } else if (modalidad_id.equals("2")) {
            numSemanas = 20;
        }

        // Actualizar los datos
        notifyDataSetChanged();  // Esto asegura que la vista se actualice con el nuevo número de semanas
    }
    @NonNull
    @Override
    public ReporteHistorialAdapter.ReportesHistorialViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(context).inflate(R.layout.historial_item, parent, false);
        return new ReporteHistorialAdapter.ReportesHistorialViewHolder(v);
    }

    public void setListaFiltrada(ArrayList<ReporteHistorial> filteredList){
        this.reportes= filteredList;
        notifyDataSetChanged();
    }

    @Override
    public void onBindViewHolder(@NonNull ReporteHistorialAdapter.ReportesHistorialViewHolder holder, int position) {
        // Imprimir los datos del reporte
        holder.imprimir(position);
    }

    @Override
    public int getItemCount() {
        return reportes.size();
    }

    public void clear() {
        reportes.clear();
        notifyDataSetChanged();
    }

    public void addAll(ArrayList<ReporteHistorial> list) {
        reportes = list;
        notifyDataSetChanged();
    }

    public class ReportesHistorialViewHolder extends RecyclerView.ViewHolder {

        TableLayout tblSemanas;  // Un solo TableLayout para encabezados y datos

        public ReportesHistorialViewHolder(@NonNull View itemView) {
            super(itemView);
            tblSemanas = itemView.findViewById(R.id.tblSemanas);  // Un solo TableLayout
        }

        public void imprimir(int position) {
            ReporteHistorial reporte = reportes.get(position);

            // Crear la fila de datos
            TableRow rowData = new TableRow(itemView.getContext());

            // Configuración común para los datos
            String[] data = {reporte.getTarjeton(), reporte.getNombre_poblacion(), reporte.getNombre_completo(), reporte.getMonto_prestado(), reporte.getPago_semanal()};
            int[] widths = {200, 300, 590, 320, 290};

            // Agregar los datos de las primeras 4 columnas
            for (int i = 0; i < data.length; i++) {
                TextView tvData = new TextView(itemView.getContext());
                tvData.setText(data[i]);
                tvData.setGravity(Gravity.CENTER);
                tvData.setTextSize(12);
                tvData.setTextColor(ContextCompat.getColor(itemView.getContext(), R.color.black));
                tvData.setPadding(10, 0, 10, 10);
                TableRow.LayoutParams layoutParams = new TableRow.LayoutParams(widths[i], 100);  // Ancho fijo para cada columna
                tvData.setLayoutParams(layoutParams);
                rowData.addView(tvData);
            }
            //Log.d("PRESTAMOS", "Parámetros numSemanas: " + numSemanas);
            // Agregar los datos de las semanas
            for (int i = 1; i <= numSemanas; i++) {
                //Log.d("PRESTAMOS", "Parámetros EN FOR numSemanas: " + numSemanas);
                String detalleSemana = reporte.getDetallesSemanas().get(i);
                //Log.d("filtrarReporte", "detalleSemana en adapter.............: " + detalleSemana);

                if (detalleSemana == null) {
                    detalleSemana = "";
                }

                // Extraer la fecha (todo antes del primer <br>)
                String fechaOriginal = "";
                if (detalleSemana.contains("<br>")) {
                    fechaOriginal = detalleSemana.split("<br>")[0];  // Toma la parte antes del primer <br>
                }

                // Formatear la fecha si está disponible
                String fechaFormateada = "";
                try {
                    if (!fechaOriginal.isEmpty()) {
                        // Suponiendo que la fecha original está en formato yyyy-MM-dd
                        SimpleDateFormat formatoEntrada = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()); // Formato original
                        SimpleDateFormat formatoSalida = new SimpleDateFormat("dd-MM-yyyy", Locale.getDefault()); // Formato deseado

                        Date fecha = formatoEntrada.parse(fechaOriginal);
                        if (fecha != null) {
                            fechaFormateada = formatoSalida.format(fecha);  // Convierte la fecha al formato dd-MM-yyyy
                        }
                    }
                } catch (ParseException e) {
                    e.printStackTrace();
                } catch (java.text.ParseException e) {
                    throw new RuntimeException(e);
                }

                // Reemplazar la fecha en detalleSemana con la fecha formateada
                if (!fechaFormateada.isEmpty()) {
                    // Reemplazar solo la parte de la fecha, antes del primer <br>
                    detalleSemana = detalleSemana.replace(fechaOriginal, fechaFormateada);
                }

                int estadoPago = reporte.getEstadoPagoSemana(i);  // Obtener el estado de pago para la semana

                // Asignar color de fondo según el estado del pago
                int colorFondo;
                switch (estadoPago) {
                    case -1:
                        colorFondo = ContextCompat.getColor(itemView.getContext(), R.color.danger);  // Rojo para estado -1
                        break;
                    case 4:
                        colorFondo = ContextCompat.getColor(itemView.getContext(), R.color.placeholder);  // Gris para estado 0
                        break;
                        case 0:
                        colorFondo = ContextCompat.getColor(itemView.getContext(), R.color.white);  // Gris para estado 0
                        break;
                    case 1:
                        colorFondo = ContextCompat.getColor(itemView.getContext(), R.color.success_custom);  // Verde para estado 1
                        break;
                    case 2:
                        colorFondo = ContextCompat.getColor(itemView.getContext(), R.color.info_custom);  // Azul cielo para estado 2
                        break;
                    case 3:
                        colorFondo = ContextCompat.getColor(itemView.getContext(), R.color.warning);  // Amarillo para estado 3
                        break;
                    default:
                        colorFondo = ContextCompat.getColor(itemView.getContext(), R.color.white);  // Fondo transparente si no hay estado
                        break;
                }

                // Crear la vista TextView para la semana
                TextView tvSemanaData = new TextView(itemView.getContext());

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                    tvSemanaData.setText(Html.fromHtml(detalleSemana, Html.FROM_HTML_MODE_LEGACY));
                } else {
                    tvSemanaData.setText(Html.fromHtml(detalleSemana));
                }

                // Configuración de estilo
                tvSemanaData.setGravity(Gravity.CENTER);
                tvSemanaData.setTextSize(12);
                tvSemanaData.setTextColor(ContextCompat.getColor(itemView.getContext(), R.color.black));
                tvSemanaData.setPadding(10, 0, 10, 30);

                // Asignar el color de fondo basado en el estado del pago
                tvSemanaData.setBackgroundColor(colorFondo);

                // Configurar el alto y ancho para que se ajusten automáticamente
                TableRow.LayoutParams layoutParams = new TableRow.LayoutParams(
                        280,  // Ancho automático
                        TableRow.LayoutParams.WRAP_CONTENT   // Alto automático
                );
                tvSemanaData.setLayoutParams(layoutParams);

                // Agregar la celda al TableRow
                rowData.addView(tvSemanaData);
            }


            // Agregar la fila de datos al TableLayout
            tblSemanas.addView(rowData);

            // Forzar redibujado si es necesario
            tblSemanas.invalidate();
            tblSemanas.requestLayout();
        }
    }
}